package gov.va.genisis2.configuration;

import gov.va.genisis2.vo.CopyTableDomains;
import gov.va.genisis2.vo.CopyTableSource;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@Configuration
@ComponentScan(basePackages = { "gov.va.genisis2.*" })
@PropertySource("file:${jboss.server.config.dir}/genisis2.properties")
public class Genisis2TableCopyDB {

	@Value("${tablecopy.db.copy_script_cmd_filepath}")
	private String cmdFilePath;

	private String tableName;
	
	private String sourceSchemaName;
	
	private String destinationSchemaName;

	// Table Copy new Attributes
	@Value("${tablecopy.db.source.server.name}")
	private String tcSourceDataBaseServerName;

	@Value("${tablecopy.db.source.server.database.name}")
	private String tcSourceDataBaseName;

	@Value("${tablecopy.db.destination.server.name}")
	private String tcDestinationDataBaseServerName;

	@Value("${tablecopy.db.destination.user.name}")
	private String tcDestinationDataBaseUserName;

	@Value("${tablecopy.db.destination.user.password}")
	private String tcDestinationDataBaseUserPassword;

	@Value("${tablecopy.db.destination.server.database.name}")
	private String tcDestinationServerDataBaseName;

	@Value("${tablecopy.db.management.database.server.name}")
	private String tcManagementDataBaseServerName;

	@Value("${tablecopy.db.management.username}")
	private String tcManagementDataBaseUserName;

	@Value("${tablecopy.db.management.password}")
	private String tcManagementDataBaseUserPassword;

	@Value("${tablecopy.db.management.schema}")
	private String tcManagementDataBaseSchema;

	@Value("${tablecopy.db.source.user.name}")
	private String tcSourceDataBaseUserName;
	
	@Value("${tablecopy.db.management.database.name}")
	private String tcManagementDataBaseName;
	
	@Value("${tablecopy.db.temporary.database.name}")
	private String tcTemporaryDataBaseName;
	

	
	
	

	/**
	 * @return the tableName
	 */
	public String getTableName() {
		return tableName;
	}




	public String getCmdFilePath() {
		return cmdFilePath;
	}
	
	
	

	/**
	 * @return the sourceSchemaName
	 */
	public String getSourceSchemaName() {
		return sourceSchemaName;
	}

	/**
	 * @param sourceSchemaName the sourceSchemaName to set
	 */
	public void setSourceSchemaName(String sourceSchemaName) {
		this.sourceSchemaName = sourceSchemaName;
	}

	/**
	 * @return the destinationSchemaName
	 */
	public String getDestinationSchemaName() {
		return destinationSchemaName;
	}

	/**
	 * @param destinationSchemaName the destinationSchemaName to set
	 */
	public void setDestinationSchemaName(String destinationSchemaName) {
		this.destinationSchemaName = destinationSchemaName;
	}
	
	
	

	@Bean
	protected CopyTableDomains getCopyTableDomainDetails() {
		return new CopyTableDomains(tcSourceDataBaseName,
				tcDestinationServerDataBaseName, tcSourceDataBaseServerName,
				tcDestinationDataBaseServerName, tcSourceDataBaseUserName,
				tcDestinationDataBaseUserName);
	}

	@Bean
	protected CopyTableSource getCopyTableSource() {
		return new CopyTableSource(tableName, tcSourceDataBaseServerName,
				tcSourceDataBaseName, 
				sourceSchemaName,
				tcDestinationDataBaseServerName, tcDestinationDataBaseUserName,
				tcDestinationDataBaseUserPassword,
				tcDestinationServerDataBaseName, 
				destinationSchemaName,
				tcManagementDataBaseServerName, tcManagementDataBaseUserName,
				tcManagementDataBaseUserPassword, tcManagementDataBaseSchema,
				cmdFilePath,
				tcManagementDataBaseName,tcTemporaryDataBaseName
				);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Genisis2TableCopyDB [cmdFilePath=" + cmdFilePath
				+ ", tableName=" + tableName
				+ ", tcSourceDataBaseServerName=" + tcSourceDataBaseServerName
				+ ", tcSourceDataBaseName=" + tcSourceDataBaseName
				+ ", tcSourceDataBaseSchema=" 
				+ sourceSchemaName
				+ ", tcDestinationDataBaseServerName="
				+ tcDestinationDataBaseServerName
				+ ", tcDestinationDataBaseUserName="
				+ tcDestinationDataBaseUserName
				+ ", tcDestinationDataBaseUserPassword="
				+ tcDestinationDataBaseUserPassword
				+ ", tcDestinationServerDataBaseName="
				+ tcDestinationServerDataBaseName
				+ ", tcDestinationDataBaseSchema="
				+ destinationSchemaName
				+ ", tcManagementDataBaseServerName="
				+ tcManagementDataBaseServerName
				+ ", tcManagementDataBaseUserName="
				+ tcManagementDataBaseUserName
				+ ", tcManagementDataBaseUserPassword="
				+ tcManagementDataBaseUserPassword
				+ ", tcManagementDataBaseSchema=" + tcManagementDataBaseSchema
				+ ", tcSourceDataBaseUserName=" + tcSourceDataBaseUserName
				+ "]";
	}

	@Bean
	public static PropertySourcesPlaceholderConfigurer placeHolderConfigurer() {
		return new PropertySourcesPlaceholderConfigurer();
	}
}
